texture Tex;

float Offset;
float Power;
float Freq;

sampler2D g_samSrcColor =
sampler_state
{
    Texture = <Tex>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = Point;
};
 
// Input and Output Semantics 
struct VS_INPUT 
{ 
   float4 position : POSITION; 
   float2 texCoord : TEXCOORD; 
}; 
struct VS_OUTPUT 
{ 
   float4 position : POSITION; 
   float2 texCoord : TEXCOORD;    
}; 
#define PS_INPUT VS_OUTPUT 

//Vertex Shader Output
VS_OUTPUT vs_main(const VS_INPUT IN) 
{ 
   VS_OUTPUT OUT; 
   OUT.position = IN.position; 
   OUT.texCoord = IN.texCoord; 
   return OUT; 
} 

// Pixel Shader Output
float4 ps_main( float2 Tex : TEXCOORD0  ) : COLOR0 
{ 
	float dx = 0;
	float dy = 0;
	float4 c;

	float yy = Tex.y - .5;
	dx = sin(yy*10*Freq + Offset)*Power;
	c.r = tex2D(g_samSrcColor, Tex + float2(dx,dy)).r;		
	
	dx = sin(yy*7*Freq + Offset + 10)*Power;
	c.g = tex2D(g_samSrcColor, Tex + float2(dx,dy)).g;		

	dx = sin(yy*5*Freq + Offset + 15)*Power;
	c.b = tex2D(g_samSrcColor, Tex + float2(dx,dy)).b;		

	c.a = 1;	
	return c;
} 

//Technique Calls
technique PostProcess 
{ 
   pass Pass_0 
   { 
      VertexShader = compile vs_1_1 vs_main(); 
      PixelShader = compile ps_2_0 ps_main(); 
   } 
} 
